<?php
/**
 * micky functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package micky
 */
if ( ! function_exists( 'micky_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function micky_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on micky, use a find and replace
	 * to change 'micky' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'micky', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support('post-thumbnails',array('post')); 
	add_image_size( 'micky-blog-single', 750, 575 );
	add_image_size( 'micky-blog-full', 1140, 350 );
	add_image_size( 'micky-blog-small', 750, 350 );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'micky' => esc_html__( 'Micky Header Menu', 'micky' ),
	) );
	
	// Setup the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'micky_custom_background_args', array(
		'default-color' => 'f1f1f1',
		'default-image' => '',
	) ) );
	
	/*implimenting new feature from 4.5*/
	add_theme_support( 'custom-logo', array(
	   'header-text' => array( 'site-title', 'site-description' ),
	   'flex-width' => true
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'gallery',
		'caption',
	) );
	
	add_editor_style( array(  get_template_directory_uri() . 'assets/css/fonts.css') );
}
endif;
add_action( 'after_setup_theme', 'micky_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function micky_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'micky_content_width', 640 );
}
add_action( 'after_setup_theme', 'micky_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function micky_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'micky' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'micky' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'micky_widgets_init' );

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/************************ start Micky Require File ************************/
require_once get_template_directory().'/vendor/functions.php';
/************************ close Micky Require File ************************/
function micky_inline_method() {
	$color = esc_attr(get_theme_mod( 'menu_color' )); //E.g. #FF0000
	$custom_css = "
		.header_top_main .mk_top_navigations ul.menu li a {
			color: {$color};
		}
		.header_top_main .mk_top_navigations > ul > li.current_page_item > a {
			border-color: {$color};
		}
		.header_top_main .mk_top_navigations > ul > li > a:hover {
			border-color: {$color};
		}";
	wp_add_inline_style( 'micky-responsive', $custom_css );
}
add_action( 'wp_enqueue_scripts', 'micky_inline_method' );
// Load Google fonts
function micky_google_fonts_url() {
    $fonts_url = '';
    $Montserrat = _x( 'on', 'Montserrat font: on or off', 'micky' );   

    if (  'off' !== $Montserrat  )
    {
        $font_families = array();
        
        if ('off' !== $Montserrat) {
            $font_families[] = 'Montserrat:100,200,300,400,500,600,700,800,900';
        }

        $query_args = array(
            'family' => urlencode(implode('|', $font_families )),
            'subset' => urlencode('latin,latin-ext')
        );

        $fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');
    }

    return esc_url_raw($fonts_url); 
}

// Google fonts
function micky_enqueue_googlefonts() {
    wp_enqueue_style( 'micky-googlefonts', micky_google_fonts_url(), array(), null );
}
add_action('wp_enqueue_scripts', 'micky_enqueue_googlefonts');
?>