<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package micky
 */
$theme_sidebar_position = $thumb_w = $thumb_h = $sidebar_layout = '';
$sidebar_layout = get_theme_mod('sidebar_layout');
if(isset($sidebar_layout) && !empty($sidebar_layout)){
	$theme_sidebar_position = get_theme_mod('sidebar_layout');
}
if(empty($sidebar_layout)){
$theme_sidebar_position = 'right';
}
?>
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
<?php if(is_single()){ ?>
<div class="blog_post_wrapper_main">
      <div class="blog_thumbnail"> 
	  <?php if (has_post_thumbnail()){ ?>
		<?php the_post_thumbnail('micky-blog-single'); ?>
	  <?php } ?>
	  </div>
     </div>
     <div class="blog_desc blog_details_desc">
      <h1><?php the_title(); ?></h1>
		<div class="bottom">
		  <?php micky_posted_on(); ?>
		</div>
      <div class="blog_content">
       <?php the_content(); ?>
      </div>
      </div>
<?php }else{ ?>
<div class="blog_post_wrapper_main">
      <div class="blog_thumbnail"> 
	  <?php if (has_post_thumbnail()){ ?> 
		<?php 
		if($theme_sidebar_position == 'full'){
			the_post_thumbnail('full');
		}else{
			the_post_thumbnail('micky-blog-small');
		}
		?>
	  <?php } ?>
	  </div>
</div>
<div class="blog_mk_title">
<h1><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h1>
</div>
<div class="blog_desc blog_details_desc mar_b_30">
	<div class="bottom">
	<?php micky_posted_on(); ?>  
		<span class="link_icon">
		<a href="<?php the_permalink(); ?>"><i class="fa fa-chevron-right"></i></a>
		</span>
	</div>
	<div class="blog_content">
		<p><?php the_content(); ?>
		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'micky' ),
				'after'  => '</div>',
			) );
		?>
		</p>
	</div>
</div>
<?php } ?>
</div><!-- #post-## -->