<?php
/**
 * Enqueue scripts.
 */
function micky_scripts() {

	wp_enqueue_script('bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array('jquery'),null,true);
	wp_enqueue_script('bootstrap-select', get_template_directory_uri() . '/assets/js/bootstrap-select-min.js', array('jquery'),null,true);
	wp_enqueue_script( 'micky-navigation', get_template_directory_uri() . '/assets/js/navigation.js', array(), '20151215', true );
	wp_enqueue_script( 'micky-skip-link-focus-fix', get_template_directory_uri() . '/assets/js/skip-link-focus-fix.js', array(), '20151215', true );
	wp_enqueue_script('micky-custom', get_template_directory_uri() . '/assets/js/custom.js', array('jquery'),null,true);

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'micky_scripts' );

/**
 * Enqueue styles.
 */
function micky_styles() {
	wp_enqueue_style('micky-defaultbasic', get_stylesheet_uri(), array(), '1', 'all');
	wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css', array(), '1', 'all');	
	wp_enqueue_style('font-awesome', get_template_directory_uri() . '/assets/css/font-awesome.css', array(), '1', 'all');
	wp_enqueue_style('line-icons', get_template_directory_uri() . '/assets/css/simple-line-icons.css', array(), '1', 'all');
	wp_enqueue_style('bootstrap-select', get_template_directory_uri() . '/assets/css/bootstrape-select.css', array(), '1', 'all');
	wp_enqueue_style('animation', get_template_directory_uri() . '/assets/css/animation.css', array(), '1', 'all');
	wp_enqueue_style('micky-style', get_template_directory_uri() . '/assets/css/custom-style.css', array(), '1', 'all');
	wp_enqueue_style('micky-responsive', get_template_directory_uri() . '/assets/css/responsive.css', array(), '1', 'all');
}
add_action( 'wp_enqueue_scripts', 'micky_styles' );
?>