<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\FieldOfficer;
use Illuminate\Support\Facades\DB;
use Auth;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class FieldOfficersController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //get a list of all businesses belonging to the user
        $fieldofficers = FieldOfficer::all();
        return view('admin.fieldofficers.index')->with('fieldofficers',$fieldofficers);
    }
    public function filter($filter_by, $filter_value)
    {
        //get a list of all businesses belonging to the user
        $shops = Shop::all();
        return view('admin.shops.index')->with('shops',$shops);
    }
    public function search(Request $request)
    {
        if($request->search_by == 'name'){
            $fieldofficers = FieldOfficer::where('first_name','LIKE',"{$request->name}%")->get();
            if(count($fieldofficers)>0){
                return view('admin.fieldofficers.index')->with('fieldofficers', $fieldofficers);
            }
            else{
                return redirect('fieldofficers')->withFail('Field Officer not found');
            }
            
        }
    }
    public function searchAjax(Request $request)
    {
        $validatedData = $request->validate([
            'name' => ['required'],
        ]);
        $result = DB::table('field_officers')
            ->where('first_name', 'like', $request->name. '%')
            ->get(); 
            if(count($result)>0){
                return response()->json(array('fieldofficers'=> $result), 200);
                //return "OK";
            }
            else{
                return response()->json(array('fieldofficers'=> ""), 200);
                //return "Not Found";
            }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.fieldofficers.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //validate customer entry, store and set view to list of customers
        $validatedData = $request->validate([
            'firstname' => ['required'],
            'lastname' => ['required'],
            'phone' => ['required'],
        ]);

        $fieldofficer = new FieldOfficer;
        if($request->photo != ""){

            $allowedfileExtension=['jpeg','jpg','png'];
    
            $name = $request->file('photo')->getClientOriginalName();
            $extension = $request->photo->getClientOriginalExtension();
            $check = in_array($extension,$allowedfileExtension);
            if($check){
                $path = $request->file('photo')->store('public/images/profile_images');
                
                $fieldofficer->profile_photo = $path;
            }
        }
          
        $fieldofficer->first_name = $request->firstname;
        $fieldofficer->last_name = $request->lastname;
        $fieldofficer->phone = $request->phone;

        $fieldofficer->save();

        $user = new User();
        $user->name = $fieldofficer->first_name . ' '. $fieldofficer->last_name;
        $user->user_type = 'fieldofficer';
        $user->password = Hash::make($fieldofficer->phone);
        $user->email = 'fieldofficer'.$fieldofficer->id.'@haraji.com';
        $user->save();

        $fieldofficer->user_id = $user->id;
        $fieldofficer->save();
        
        return redirect('fieldofficers')->with('status', 'Field Officer was added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $fieldofficer = FieldOfficer::findOrFail($id);
        return view('admin.fieldofficers.show')->with('fieldofficer',$fieldofficer);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'firstname' => ['required'],
            'lastname' => ['required'],
            'phone' => ['required'],
        ]);

        $fieldofficer = FieldOfficer::find($id);
        if($request->photo != ""){

            $allowedfileExtension=['jpeg','jpg','png'];
    
            $name = $request->file('photo')->getClientOriginalName();
            $extension = $request->photo->getClientOriginalExtension();
            $check = in_array($extension,$allowedfileExtension);
            if($check){
                $path = $request->file('photo')->store('public/images/profile_images');
                
                $fieldofficer->profile_photo = $path;
            }
        }
          
        $fieldofficer->first_name = $request->firstname;
        $fieldofficer->last_name = $request->lastname;
        $fieldofficer->phone = $request->phone;

        $fieldofficer->save();
        
        return redirect('fieldofficers')->with('status', 'Field Officer was updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
