<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Shop;

class PagesController extends Controller
{
    /**
     * Show the search page.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function search()
    {
        return view('search');
    }
    public function request()
    {
        return view('request');
    }

    public function displaySearchResult(Request $request)
    {
        $validatedData = $request->validate([
            'transaction_ref_no' => ['required'],
            'allocation_no' => ['required'],
        ]);
        $shops = Shop::where('allocation_no',"{$request->allocation_no}")->get();
        //return $shops;
        return view('search-result')->with('shops',$shops);
    }

    public function searchShopAjax(Request $request)
    {
        $validatedData = $request->validate([
            'allocation_no' => ['required'],
        ]);
        $shop = Shop::where('allocation_no',"{$request->allocation_no}")->get();
        if(count($shop)>0){
            return response()->json(array('shop'=> "Ok"), 200);
            //return "OK";
        }
        else{
            return response()->json(array('shop'=> ""), 404);
            //return "Not Found";
        }
    }

    public function requestShopSearchAjax(Request $request)
    {
        $validatedData = $request->validate([
            'market' => ['required'],
        ]);
        $shops = Shop::where('market',"{$request->market}")->where('status',"{$request->status}")->get();
        if(count($shops)>0){
            return response()->json(array('shops'=> $shops), 200);
        }
        else{
            return response()->json(array('shops'=> $shops), 404);
        }
    }
    

    public function fieldofficerLogin()
    {
        return view('fieldofficer.login');
    }

    public function corporateLogin()
    {
        return view('corporate.login');
    }

    public function bulkupload()
    {
        return view('admin.bulkupload');
    }
}
