<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Shop;
use App\Models\ShopOwnership;
use Illuminate\Support\Facades\DB;
use Auth;

class ShopsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //get a list of all businesses belonging to the user
        $shops = Shop::all();
        $view = Auth::user()->user_type . '.shops.index';
        return view($view)->with('shops',$shops);
    }
    public function filter($filter_by, $filter_value)
    {
        //get a list of all businesses belonging to the user
        $shops = Shop::all();
        return view('admin.shops.index')->with('shops',$shops);
    }
    public function search(Request $request)
    {
        if($request->search_by == 'allocation_no'){
            $shops = Shop::where('allocation_no',"{$request->allocation_no}")->get();
            if(count($shops)>0){
                return view('admin.shops.index')->with('shops', $shops);
            }
            else{
                return redirect('shops')->withFail('Shop not found');
            }
            
        }
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.shops.create');
    }

    public function assign()
    {
        if(Auth::user()->user_type == 'admin'){
            return view('admin.shops.index');
        }
        if(Auth::user()->user_type == 'fieldofficer'){
            return view('fieldofficer.shops.index');
        }
        
    }

    public function assignShop($id)
    {
        $shop = Shop::findOrFail($id);
        if(Auth::user()->user_type == 'admin'){
            return view('admin.shops.assign')->with('shop',$shop);
        }
        if(Auth::user()->user_type == 'fieldofficer'){
            return view('fieldofficer.shops.assign')->with('shop',$shop);
        }
        
    }



    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //validate customer entry, store and set view to list of customers
        $validatedData = $request->validate([
            'allocation_no' => ['required'],
            'market' => ['required'],
            'block' => ['required'],
            'shop_no' => ['required'],
            'status' => ['required'],
        ]);
        
        $shop = new Shop;
        $shop->allocation_no = $request->allocation_no;
        $shop->market = $request->market;
        $shop->block = $request->block;
        $shop->shop_no = $request->shop_no;
        $shop->status = $request->status;
        $shop->unique_identifier = uniqid();

        $shop->save();
        
        return redirect('shops')->with('status', 'Shop was added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $shop = Shop::findOrFail($id);
        if(Auth::user()->user_type == 'admin'){
            return view('admin.shops.show')->with('shop',$shop);
        }
        if(Auth::user()->user_type == 'fieldofficer'){
            return view('fieldofficer.shops.show')->with('shop',$shop);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //validate customer entry, store and set view to list of customers
        $validatedData = $request->validate([
            'allocation_no' => ['required'],
            'market' => ['required'],
            'block' => ['required'],
            'shop_no' => ['required'],
            'status' => ['required'],
        ]);
        
        $shop = Shop::find($id);
        $shop->allocation_no = $request->allocation_no;
        $shop->market = $request->market;
        $shop->block = $request->block;
        $shop->shop_no = $request->shop_no;
        $shop->status = $request->status;
        if($request->has('shop_owner_id')){
            $shop->shop_owner_id = $request->shop_owner_id;
            //store details in shop ownership history
            $shopownership = new ShopOwnership;
            $shopownership->user_id = Auth::id();
            $shopownership->shop_id = $shop->id;
            $shopownership->shop_owner_id = $shop->shop_owner_id;
            $shopownership->save();
        }

        $shop->save();
        
        return redirect('shops')->with('status', 'Shop was updated successfully');
    }

    public function assignShopToShopOwner(Request $request, $id)
    {
        //validate customer entry, store and set view to list of customers
        $validatedData = $request->validate([
            'shop_owner_id' => ['required'],
        ]);
        
        $shop = Shop::find($id);
        $shop->shop_owner_id = $request->shop_owner_id;

        $shop->save();
        
        return redirect('shops')->with('status', 'Shop was updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
