@extends('layouts.admin')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Create Field Officer') }}</div>

                <div class="card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form action="{{ url('fieldofficers/') }}" method="post" enctype="multipart/form-data">
                    @csrf
                        <div class="form-group">
                            <input type="text" name="firstname" class="form-control" placeholder="First Name" >  
                        </div>
                        <div class="form-group">
                            <input type="text" name="lastname" class="form-control" placeholder="Last Name" >  
                        </div>
                        <div class="form-group">
                            <input type="text" name="phone" class="form-control" placeholder="Phone Number" aria-label="Enter Shop No">  
                        </div>
                        <div class="form-group">
                            <input type="file" name="photo" class="form-control" >  
                        </div>
                        <div class="form-group">
                        <button type="submit" class="btn btn-outline-success">Create</button>  
                        </div>
                    </form>
                </div>

            </div>
            
            
            
        </div>
    </div>
</div>
@endsection
