@extends('layouts.admin')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Create Shop') }}</div>

                <div class="card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form action="{{ url('shops/') }}" method="post">
                    @csrf
                        <div class="form-group">
                            <input type="text" name="allocation_no" class="form-control" placeholder="Enter Allocation No" aria-label="Enter Allocation No">  
                        </div>
                        <div class="form-group">
                            <select class="form-select form-control" name="market">
                                <option value="">Select Market</option>
                                <option value="Wuse">Wuse</option>
                                <option value="Garki">Garki</option>
                            </select>
                        </div>
                        <div class="form-group">
                        <select class="form-select form-control" name="block">
                                <option value="">Select Block</option>
                                <option value="A">A</option>
                                <option value="B">B</option>
                                <option value="C">C</option>
                                <option value="D">D</option>
                                <option value="E">E</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <input type="text" name="shop_no" class="form-control" placeholder="Enter Shop No" aria-label="Enter Shop No">  
                        </div>
                        <div class="form-group">
                        <select class="form-select form-control" name="status"><option value="">Status</option>
                        <option value="0">InActive</option><option value="1">Active</option>
                        <option value="2">Available For Rent</option><option value="3">ActAvailable For Purchase</option>
                        </select> 
                        </div>
                        <div class="form-group">
                        <button type="submit" class="btn btn-outline-success">Create</button>  
                        </div>
                    </form>
                </div>

            </div>
            
            
            
        </div>
    </div>
</div>
@endsection
