@extends('layouts.admin')

@section('content')
<style>
.shop{
    cursor:hand; 
    background: #fff;
}
.shop:hover {background: #f5f5f5;}
</style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('View All Shops/Search For Shops') }}</div>

                <div class="card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    @if(Session::has('fail'))
                        <div class="alert alert-danger">
                        {{Session::get('fail')}}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-4">
                            <a href="{{ url('shops/create') }}" class="btn btn-outline-success" >Create Shop</a>
                        </div>
                        <div class="col-8">
                            <a href="{{ url('admin-bulkupload') }}" class="btn btn-outline-success" >Bulk Upload</a>
                        </div>
                    </div>
                </div>

            </div>
            
            <div class="card">
                <div class="card-header">{{ __('Search/Filter') }}</div>

                <div class="card-body">
                    <form action="{{ url('/admin-shops-search') }}" method="get">
                        <div class="input-group mb-3">
                            <input type="hidden" name="search_by" value="allocation_no"/>
                            <input type="text" name="allocation_no" class="form-control" placeholder="Enter Allocation No" aria-label="Enter Allocation No" aria-describedby="button-addon2">
                            <button class="btn btn-outline-success" type="sumbit" id="">Search</button>
                        </div>
                    </form>
                    
                    <form>
                        <div class="row">
                            <div class="col">
                            <select class="form-select form-control" name="market">
                                <option value="">Select Market</option>
                                <option value="Wuse">Wuse</option>
                                <option value="Garki">Garki</option>
                            </select>
                            </div>
                            <div class="col">
                            <select class="form-select form-control" name="block">
                                <option value="">Select Block</option>
                                <option value="A">A</option>
                                <option value="B">B</option>
                                <option value="C">C</option>
                                <option value="D">D</option>
                                <option value="E">E</option>
                            </select>
                            </div>
                            <div class="col">
                            <button type="button" class="btn btn-outline-success">Filter</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card">
                <div class="card-header">{{ __('Result/List') }}</div>

                <div class="card-body">
                    <div class="row" style="background-color: rgba(39,41,43,0.03);">
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __('Market') }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __('Block') }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __('Number') }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __('Shop Owner') }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __('Status') }}
                        </div>
                    </div>
                    
                    @foreach($shops ?? [] as $shop)
                    <div class="row shop table table-hover" data-id="{{$shop->id}}" style="">
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __($shop->market) }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __($shop->block) }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __($shop->shop_no) }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __($shop->shopOwner->first_name ?? 'None') }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php
                            switch ($shop->status) {
                            case 0:
                                echo 'InActive';
                                break;
                            case 1:
                                echo 'Active';
                                break;
                            case 2:
                                echo 'For Rent';
                                break;
                            case 3:
                                echo 'For Sale';
                                break;
                            default:
                                echo "";
                            }
                            ?>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
<script>
window.addEventListener('load', function() {
                            $(".shop").on("click", function(){
                                
                                var id = $(this).attr("data-id");
                                var url = "{{ url('shops/') }}/"+id;

                                window.location = url;                           
                                
                            });
                        })
</script>
