<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/search', [App\Http\Controllers\PagesController::class, 'search'])->name('search');
Route::get('/request', [App\Http\Controllers\PagesController::class, 'request'])->name('request');
Route::get('/corporate-login', [App\Http\Controllers\PagesController::class, 'corporateLogin'])->name('corporateLogin');
Route::get('/fieldofficer-login', [App\Http\Controllers\PagesController::class, 'fieldofficerLogin'])->name('fieldofficerLogin');
Route::get('/admin-shops-search', [App\Http\Controllers\ShopsController::class, 'search'])->name('adminsearchshop');
Route::get('/admin-shopowners-search', [App\Http\Controllers\ShopOwnersController::class, 'search'])->name('adminsearchshopowner');
Route::get('/admin-shopowners-search-ajax', [App\Http\Controllers\ShopOwnersController::class, 'searchAjax'])->name('adminsearchshopownerajax');
Route::get('/admin-fieldofficers-search', [App\Http\Controllers\FieldOfficersController::class, 'search'])->name('adminsearchfieldofficer');
Route::get('/admin-bulkupload', [App\Http\Controllers\PagesController::class, 'bulkupload'])->name('adminsearchfieldofficer');

Route::post('/guest-search-shop-ajax', [App\Http\Controllers\PagesController::class, 'searchShopAjax'])->name('guestsearchshopajax');

Route::post('/guest-search-display-result', [App\Http\Controllers\PagesController::class, 'displaySearchResult'])->name('displaySearchResult');

Route::post('/guest-shop-request-search-ajax', [App\Http\Controllers\PagesController::class, 'requestShopSearchAjax'])->name('requestShopSearchAjax');

Route::resources([
    'shops' => App\Http\Controllers\ShopsController::class,
    'shopowners' => App\Http\Controllers\ShopOwnersController::class,
    'fieldofficers' => App\Http\Controllers\FieldOfficersController::class,
]);
Route::get('/assign-shop', [App\Http\Controllers\ShopsController::class, 'assign'])->name('assign');
Route::get('/assignshop/{id}', [App\Http\Controllers\ShopsController::class, 'assignShop'])->name('assignShop');
