<?php $__env->startSection('content'); ?>
<style>
.shop{
    cursor:hand; 
    background: #fff;
}
.shop:hover {background: #f5f5f5;}
</style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header"><?php echo e(__('View All Shops/Search For Shops')); ?></div>

                <div class="card-body">
                    <?php if(session('status')): ?>
                        <div class="alert alert-success" role="alert">
                            <?php echo e(session('status')); ?>

                        </div>
                    <?php endif; ?>
                    <?php if(Session::has('fail')): ?>
                        <div class="alert alert-danger">
                        <?php echo e(Session::get('fail')); ?>

                        </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-4">
                            <a href="<?php echo e(url('shops/create')); ?>" class="btn btn-outline-success" >Create Shop</a>
                        </div>
                        <div class="col-8">
                            <a href="<?php echo e(url('admin-bulkupload')); ?>" class="btn btn-outline-success" >Bulk Upload</a>
                        </div>
                    </div>
                </div>

            </div>
            
            <div class="card">
                <div class="card-header"><?php echo e(__('Search/Filter')); ?></div>

                <div class="card-body">
                    <form action="<?php echo e(url('/admin-shops-search')); ?>" method="get">
                        <div class="input-group mb-3">
                            <input type="hidden" name="search_by" value="allocation_no"/>
                            <input type="text" name="allocation_no" class="form-control" placeholder="Enter Allocation No" aria-label="Enter Allocation No" aria-describedby="button-addon2">
                            <button class="btn btn-outline-success" type="sumbit" id="">Search</button>
                        </div>
                    </form>
                    
                    <form>
                        <div class="row">
                            <div class="col">
                            <select class="form-select form-control" name="market">
                                <option value="">Select Market</option>
                                <option value="Wuse">Wuse</option>
                                <option value="Garki">Garki</option>
                            </select>
                            </div>
                            <div class="col">
                            <select class="form-select form-control" name="block">
                                <option value="">Select Block</option>
                                <option value="A">A</option>
                                <option value="B">B</option>
                                <option value="C">C</option>
                                <option value="D">D</option>
                                <option value="E">E</option>
                            </select>
                            </div>
                            <div class="col">
                            <button type="button" class="btn btn-outline-success">Filter</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card">
                <div class="card-header"><?php echo e(__('Result/List')); ?></div>

                <div class="card-body">
                    <div class="row" style="background-color: rgba(39,41,43,0.03);">
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php echo e(__('Market')); ?>

                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php echo e(__('Block')); ?>

                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php echo e(__('Number')); ?>

                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php echo e(__('Shop Owner')); ?>

                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php echo e(__('Status')); ?>

                        </div>
                    </div>
                    
                    <?php $__currentLoopData = $shops ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row shop table table-hover" data-id="<?php echo e($shop->id); ?>" style="">
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php echo e(__($shop->market)); ?>

                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php echo e(__($shop->block)); ?>

                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php echo e(__($shop->shop_no)); ?>

                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php echo e(__($shop->shopOwner->first_name ?? 'None')); ?>

                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php
                            switch ($shop->status) {
                            case 0:
                                echo 'InActive';
                                break;
                            case 1:
                                echo 'Active';
                                break;
                            case 2:
                                echo 'For Rent';
                                break;
                            case 3:
                                echo 'For Sale';
                                break;
                            default:
                                echo "";
                            }
                            ?>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<script>
window.addEventListener('load', function() {
                            $(".shop").on("click", function(){
                                
                                var id = $(this).attr("data-id");
                                var url = "<?php echo e(url('shops/')); ?>/"+id;

                                window.location = url;                           
                                
                            });
                        })
</script>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/fortranh/public_html/demo/haraji-prototype/resources/views/admin/shops/index.blade.php ENDPATH**/ ?>