<script src="<?php echo e(asset('public/js/qrcode.js')); ?>" defer></script>
<?php $__env->startSection('content'); ?>
<style>
.input-group{
    margin-bottom: 10px;
}
</style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header"><?php echo e(__('Shop Details')); ?></div>

                <div class="card-body">
                    <?php if(session('status')): ?>
                        <div class="alert alert-success" role="alert">
                            <?php echo e(session('status')); ?>

                        </div>
                    <?php endif; ?>
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <form action="<?php echo e(url('shops/'.$shop->id)); ?>" method="post">
                    <?php echo csrf_field(); ?>
                        <div class="input-group">
                            <span class="input-group-text" id="inputGroup-sizing-default">Alocation No:</span>
                            <input type="text" value="<?php echo e(__($shop->allocation_no ?? 'None')); ?>" name="allocation_no" class="form-control" placeholder="Enter Allocation No" aria-label="Enter Allocation No">  
                        </div>
                        <div class="input-group">
                            <label class="input-group-text" for="market">Market</label>
                            <select class="form-select form-control" data-market="<?php echo e(__($shop->market ?? 'None')); ?>" name="market" id="market">
                                <option value="">Select Market</option>
                                <option value="Wuse">Wuse</option>
                                <option value="Garki">Garki</option>
                            </select>
                            <script>
                            </script>
                        </div>
                        <div class="input-group">
                            <label class="input-group-text" for="block">Block</label>
                            <select class="form-select form-control" data-block="<?php echo e(__($shop->block ?? 'None')); ?>" name="block" id="block">
                                <option value="">Select Block</option>
                                <option value="A">A</option>
                                <option value="B">B</option>
                                <option value="C">C</option>
                                <option value="D">D</option>
                                <option value="E">E</option>
                            </select>
                        </div>
                        <div class="input-group">
                            <span class="input-group-text" id="">Shop No:</span>
                            <input type="text" value="<?php echo e(__($shop->shop_no ?? 'None')); ?>" name="shop_no" class="form-control" placeholder="Enter Shop No" aria-label="Enter Shop No">  
                        </div>
                        <div class="input-group">
                            <label class="input-group-text" for="block">Status</label>
                            <select class="form-select form-control" data-status="<?php echo e(__($shop->status ?? 'None')); ?>" name="status"id="status">
                            <option value="">Status</option><option value="0">InActive</option>
                            <option value="1">Active</option><option value="2">Available For Rent</option>
                            <option value="3">Available For Purchase</option>
                            </select> 
                        </div>
                        <div class="input-group">
                            <span class="input-group-text" id="">Shop Owner:</span>
                            <input type="text" value="<?php echo e(__($shop->shopOwner ? $shop->shopOwner->name() : 'None')); ?>" class="form-control" readonly > 
                            <button type="button" data-id="<?php echo e($shop->id ?? ''); ?>" class="btn btn-outline-secondary assign"><?php echo e(__( !$shop->shopowner ? 'Assign' : 'Re-Assign')); ?></button> 
                        </div>
                        <div class="input-group">
                            <span class="input-group-text" id="">Unique Identifier:</span>
                            
                            <input type="text" value="<?php echo e(__($shop->unique_identifier ?? 'None')); ?>" name="unique_identifier" class="form-control" readonly>  
                        </div>
                        
                        <div class="form-group">
                        <input type="hidden" name="_method" value="PUT">
                        <button type="submit" class="btn btn-outline-success">Update</button>  
                        </div>
                    </form>
                </div>

            </div>

            <div class="card">
                <div class="card-header"><?php echo e(__('Shop QR Code')); ?></div>

                <div class="card-body">
                    <div id="qrcode" style="margin-bottom:10px"></div>
                    <button type="button" class="btn btn-outline-secondary downloadqr">Download</button>
                </div>
            </div>
            <div class="card">
                

                <div class="card-body">
                    
                <a href="<?php echo e(asset('storage/app/public/Picture1.jpg/')); ?>" class="btn btn-outline-success" >Download Shop File</a>
                </div>
            </div>
            
            
            <div class="card">
                <div class="card-header"><?php echo e(__('Shop Ownership History')); ?></div>

                <div class="card-body">
                    <div class="row" style="background-color: rgba(39,41,43,0.03);">
                        <div class="col-2" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php echo e(__('Date')); ?>

                        </div>
                        <div class="col-5" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php echo e(__('Shop Owner')); ?>

                        </div>
                        <div class="col-5" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php echo e(__('Assigned By')); ?>

                        </div>
                        
                    </div>
                    
                    <?php $__currentLoopData = $shop->shopOwnerships ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shopOwnership): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row shop table table-hover" data-id="<?php echo e($shop->id); ?>" style="">
                        <div class="col-2" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php echo e(__($shopOwnership->created_at->format('d M Y'))); ?>

                        </div>
                        <div class="col-5" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php 
                            
                            $shopowner = App\Models\ShopOwner::find($shopOwnership->shop_owner_id);
                            ?>
                            <?php echo e(__($shopowner->name())); ?>

                            
                        </div>
                        <div class="col-5" style="border: 1px solid rgba(39,41,43,0.1);">
                            <?php 
                            //use App\Models\User;
                            $user = App\Models\User::find($shopOwnership->user_id);
                            ?>
                            <?php echo e(__($user->name)); ?>

                            
                        </div>
                        
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<script>
window.addEventListener('load', function() {
    var market = $('#market').attr("data-market");
    $('#market option[value='+market+']').attr('selected','selected');
    var block = $('#block').attr("data-block");
    $('#block option[value='+block+']').attr('selected','selected');
    var status = $('#status').attr("data-status");
    $('#status option[value='+status+']').attr('selected','selected');
    $(".assign").on("click", function(){
        var id = $(this).attr("data-id");
        var url = "<?php echo e(url('assignshop/')); ?>/"+id;
        window.location = url;
    })
    $(".downloadqr").on("click", function(){
        var imgUrl = $('#qrcode').children('img').attr('src');
        var a = document.createElement("a");
        a.href = imgUrl;
        a.setAttribute("download", "ShopQRCode");
        a.click();
        //alert(img);
    })
    var qrcode = new QRCode(document.getElementById("qrcode"), {
                        text: "<?php echo e(url('shops/'.$shop->id)); ?>",
                        width : 100,
                        height : 100
                    });
    })
    
</script>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/fortranh/public_html/demo/haraji-prototype/resources/views/admin/shops/show.blade.php ENDPATH**/ ?>