<?php

namespace Elementor;

class testimonial_four_Widget extends Widget_Base
{

    public function get_name()
    {

        return 'testimonial_four_Widget';
    }

    public function get_title()
    {
        return esc_html__('Tronix Testimonial V4', 'tronixcore');
    }

    public function get_icon()
    {
        return 'eicon-shape';
    }

    public function get_categories()
    {
        return ['tronixcore'];
    }

    protected function register_controls()
    {

        //Content tab start
        $this->start_controls_section(
            'Tronix_title_options',
            [
                'label' => esc_html__('Tronix Testomonial', 'tronixcore'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'name',
            [
                'label'       => esc_html__('Name', 'tronixcore'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Marvin McKinney', 'tronixcore'),
                'label_block' => true,
            ]
        );


        $repeater->add_control(
            'designation',
            [
                'label'       => esc_html__('Desiganation', 'tronixcore'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('CFO', 'tronixcore'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Tronixlogy is crucial for our understanding of the natural world, and is bTronixming increasingly important as human activities, such as pollution, deforestation, and climate change, have led to a decline.', 'tronixcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'Tronix_repeater_list',
            [
                'label'       => esc_html__('Repeater List', 'tronixcore'),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default' => [
                    [
                        'name' => esc_html__('Manaf Hasan', 'tronixcore'),
                        'designation' => esc_html__('CFO/Founder', 'tronixcore'),
                    ],
                    [
                        'name' => esc_html__('Manaf Hasan', 'tronixcore'),
                        'designation' => esc_html__('CFO/Founder', 'tronixcore'),
                    ],
                ],
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Testimonial Options', 'tronixcore'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'enable_container',
            [
                'label' => esc_html__('Enable Container', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tronixcore'),
                'label_off' => esc_html__('Hide', 'tronixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'desktop_col',
            [
                'label' => esc_html__('Columns On Desktop', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'col-xl-6',
                'options' => [
                    'col-xl-12'  => esc_html__('1 Column', 'tronixcore'),
                    'col-xl-6'  => esc_html__('2 Column', 'tronixcore'),
                    'col-xl-4'  => esc_html__('3 Column', 'tronixcore'),
                    'col-xl-3'  => esc_html__('4 Column', 'tronixcore'),
                ],
                'condition' => [
                    'enable_slide!' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'ipadpro_col',
            [
                'label' => esc_html__('Columns On Ipad Pro', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'col-lg-6',
                'options' => [
                    'col-lg-12'  => esc_html__('1 Column', 'tronixcore'),
                    'col-lg-6'  => esc_html__('2 Column', 'tronixcore'),
                    'col-lg-4'  => esc_html__('3 Column', 'tronixcore'),
                    'col-lg-3'  => esc_html__('4 Column', 'tronixcore'),
                ],
                'condition' => [
                    'enable_slide!' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'tab_col',
            [
                'label' => esc_html__('Columns On Tablet', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'col-md-12',
                'options' => [
                    'col-md-12'  => esc_html__('1 Column', 'tronixcore'),
                    'col-md-6'  => esc_html__('2 Column', 'tronixcore'),
                    'col-md-4'  => esc_html__('3 Column', 'tronixcore'),
                    'col-md-3'  => esc_html__('4 Column', 'tronixcore'),
                ],
                'condition' => [
                    'enable_slide!' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'enable_slide',
            [
                'label' => esc_html__('Enable Slide', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tronixcore'),
                'label_off' => esc_html__('Hide', 'tronixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'Tronix_enable_dots',
            [
                'label'        => esc_html__('Enable Dots ', 'tronixcore'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__('On', 'tronixcore'),
                'label_off'    => esc_html__('Off', 'tronixcore'),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition' => [
                    'enable_slide' => 'yes',
                ],

            ]
        );
        $this->add_control(
            'enable_slider_auto_loop',
            [
                'label'        => esc_html__('Enable Auto Loop ', 'tronixcore'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__('On', 'tronixcore'),
                'label_off'    => esc_html__('Off', 'tronixcore'),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition' => [
                    'enable_slide' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'slid_show_item',
            [
                'label' => esc_html__('Display Item', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 4,
                'step' => 1,
                'default' => 2,
                'condition' => [
                    'enable_slide' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'Tronix_slider_speed',
            [
                'label'     => esc_html__('Slide Speed', 'tronixcore'),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 500,
                'max'       => 8000,
                'step'      => 10,
                'default'   => 800,
                'condition' => [
                    'enable_slide' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        //=================================================//
        //========= TESTIMONIAL BOX STYLE START===========//
        //===============================================//

        $this->start_controls_section(
            'box_tab_style',
            [
                'label' => esc_html__('Box Style', 'tronixcore'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'box_backgrounds',
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .testi-v4-des,{{WRAPPER}} .testi-v4-des:after',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'box_border',
                'label'    => esc_html__('Border', 'tronixcore'),
                'selector' => '{{WRAPPER}} .testi-v4-des',
            ]
        );
        $this->add_responsive_control(
            'box_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .testi-v4-des' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow',
                'label'    => esc_html__('Box Shadow', 'tronixcore'),
                'selector' => '{{WRAPPER}} .testi-v4-des',
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .testi-v4-des' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .testi-v4-des' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();

        // 
        // ========== TESTIMONIAL Info Box ===========
        // 


        // ========== Testimonial Content ===========
        // 
        $this->start_controls_section(
            'image_Style',
            [
                'label' => esc_html__(' Image Style', 'tronixcore'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'image_height',
            [
                'label'      => esc_html__('Height', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .testi-v4-image' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_width',
            [
                'label'      => esc_html__('width', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .testi-v4-image' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'object',
            [
                'label' => esc_html__('Object Fit', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill'  => esc_html__('Fill', 'tronixcore'),
                    'contain' => esc_html__('Contain', 'tronixcore'),
                    'cover' => esc_html__('Cover', 'tronixcore'),
                    'none' => esc_html__('None', 'tronixcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .testi-v4-image' => 'object-fit: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'image_border',
                'label'    => esc_html__('Border', 'tronixcore'),
                'selector' => '{{WRAPPER}} .testi-v4-image',
            ]
        );
        $this->add_responsive_control(
            'image_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .testi-v4-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .testi-v4-image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .testi-v4-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();


        // 
        // ========== Testimonial Content ===========
        // 

        $this->start_controls_section(
            'testi_content',
            [
                'label' => esc_html__('Content', 'tronixcore'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'testi_content_tabs'
        );
        $this->start_controls_tab(
            'testi_name_tab',
            [
                'label' => esc_html__('Name', 'tronixcore'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'testi_name_typo',
                'selector' => '{{WRAPPER}} .testi-v4-name',
            ]
        );
        $this->add_responsive_control(
            'testi_name_color',
            [
                'label'     => esc_html__('Color', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-v4-name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'testi_name_Margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .testi-v4-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testi_name_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .testi-v4-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'testi_designation_tab',
            [
                'label' => esc_html__('Designation', 'tronixcore'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'testi_designation_typo',
                'selector' => '{{WRAPPER}} .testi-v4-designation',
            ]
        );
        $this->add_responsive_control(
            'testi_designation_color',
            [
                'label'     => esc_html__('Color', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-v4-designation' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'testi_designation_Margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .testi-v4-designation' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testi_designation_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .testi-v4-designation' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        //
        //=========== Dote STYLE START===========//
        //

        $this->start_controls_section(
            'dote_style',
            [
                'label' => esc_html__('Dote Style', 'tronixcore'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'Tronix_enable_dots' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'dode_background_color',
            [
                'label'     => esc_html__('Dote Color', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-dots li button' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'dote_active_color',
            [
                'label'     => esc_html__('Active Dote Color', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-dots li.slick-active button' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'dote_border',
                'selector' => '{{WRAPPER}} .slick-dots li',
            ]
        );

        $this->add_responsive_control(
            'dote_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .testi-v4-wrapper .slick-dots li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .testi-v4-wrapper .slick-dots li button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'dote_Margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .testi-v4-wrapper .slick-dots' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'dote_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .testi-v4-wrapper .slick-dots li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();


    }
    //Render
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $unique_id = rand(2585, 8241);
        if ($settings['enable_container'] == 'yes') {
            $container = 'container';
        } else {
            $container = 'container-fluid';
        }
        
        ob_start();
        if ($settings['enable_slide'] == 'yes') {
            $row = 'no-row';
            $col = 'testi-v4-coloum';
            $box = 'testi-v4-slider-box';
?>
            <script>
                jQuery(document).ready(function($) {
                    "use strict";
                    $('#testimonial-<?php echo esc_attr($unique_id); ?>').slick({
                        infinite: true,
                        rtl: <?php echo json_encode(is_rtl() == 'yes' ? true : false); ?>,
                        speed: <?php echo json_encode($settings['Tronix_slider_speed']); ?>,
                        autoplay: <?php echo json_encode($settings['enable_slider_auto_loop'] == 'yes' ? true : false); ?>,
                        arrows: false,
                        dots: <?php echo json_encode($settings['Tronix_enable_dots'] == 'yes' ? true : false); ?>,
                        slidesToShow: <?php echo json_encode($settings['slid_show_item']); ?>,
                        slidesToScroll: 1,
                        centerPadding: '60px',
                        cssEase: 'linear',
                        responsive: [
                            {
                                breakpoint: 1023,
                                settings: {
                                    slidesToShow: 2,
                                    arrows: false,
                                }
                            },
                            {
                                breakpoint: 767,
                                settings: {
                                    slidesToShow: 1,
                                    arrows: false,
                                }
                            }
                        ]
                    });
                });
            </script>
        <?php
        } else {
            $box = '';
            $row = 'row';
            $col =  'col-12 col-sm-12 ' . $settings['desktop_col'] . ' ' . $settings['ipadpro_col'] . ' ' . $settings['tab_col'] . '';
        }
        ?>
        <div class="testi-v4-wrapper">
            <div class="<?php echo esc_attr($container); ?>">
                <div class="<?php echo esc_attr($row); ?>" id="testimonial-<?php echo esc_attr($unique_id); ?>">
                    <?php foreach ($settings['Tronix_repeater_list'] as $item) : ?>
                        <div class="<?php echo esc_attr($col); ?>">
                            <div class="testi-v4-item <?php echo esc_attr($box); ?>">
                                <div class="testi-v4-des">
                                    <?php echo wp_kses($item['description'], tronix_allowhtml()); ?>
                                </div>
                                <div class="testi-v4-info">
                                    <div class="testi-v4-image">
                                        <?php echo wp_get_attachment_image($item['image']['id'], 'full'); ?>
                                    </div>
                                    <div class="testi-v4-content">
                                        <h5 class="testi-v4-name"><?php echo esc_html($item['name']); ?></h5>
                                        <div class="testi-v4-designation"> <?php echo esc_html($item['designation']); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
<?php
        echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register(new testimonial_four_Widget);
