<?php
if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
CSF::createSection( $TronixThemeOption, array(
    'title'  => esc_html__( 'Theme Color', 'tronix' ),
    'icon'   => 'fas fa-palette',
    'fields' => array(
    
        array(
            'id'       => 'enable_theme_body_color',
            'type'     => 'switcher',
            'default'  => false,
            'title'    => esc_html__( 'Enable Body Color', 'tronix' ),
            'subtitle' => esc_html__( 'Enable Body Color Here', 'tronix' ),
        ),
        array(
            'id'          => 'theme_body_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Body Color', 'tronix' ),
            'subtitle'       => esc_html__( 'Add You Color for Body', 'tronix' ),
            'dependency'  => array( 'enable_theme_body_color', '==', 'true' ),
            'output'      => 'body'
        ),
    
        array(
            'id'       => 'enable_theme_primary_color',
            'type'     => 'switcher',
            'default'  => false,
            'title'    => esc_html__( 'Enable Primary Color', 'tronix' ),
            'subtitle' => esc_html__( 'Enable Primary Color Here', 'tronix' ),
        ),
        array(
            'id'          => 'theme_primary_color',
            'type'        => 'color',
            'default'      => '#0E59F2',
            'title'       => esc_html__( 'Primary Color', 'tronix' ),
            'subtitle'       => esc_html__( 'Add You Color for Primary', 'tronix' ),
            'dependency'  => array( 'enable_theme_primary_color', '==', 'true' ),
        ),
        
        array(
            'id'       => 'enable_theme_secondary_color',
            'type'     => 'switcher',
            'default'  => false,
            'title'    => esc_html__( 'Enable Secondary Color', 'tronix' ),
            'subtitle' => esc_html__( 'Enable Secondary Color Here', 'tronix' ),
        ),
        array(
            'id'          => 'theme_secondary_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Secondary Color', 'tronix' ),
            'subtitle'       => esc_html__( 'Add You Color for Secondary', 'tronix' ),
            'dependency'  => array( 'enable_theme_secondary_color', '==', 'true' ),
        ),

        array(
            'id'       => 'enable_theme_border_color',
            'type'     => 'switcher',
            'default'  => false,
            'title'    => esc_html__( 'Enable Border Color', 'tronix' ),
            'subtitle' => esc_html__( 'Enable Border Color Here', 'tronix' ),
        ),
        array(
            'id'          => 'theme_border_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Secondary Color', 'tronix' ),
            'subtitle'       => esc_html__( 'Add You Color for Secondary', 'tronix' ),
            'dependency'  => array( 'enable_theme_border_color', '==', 'true' ),
        ),
    ),
) );